unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Mask, DBCtrls, Db, DBTables, JPEG;

type
  TForm1 = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    DBNavigator1: TDBNavigator;
    DBEdit1: TDBEdit;
    Image1: TImage;
    Label1: TLabel;
    OpenDialog1: TOpenDialog;
    Table1Descricao: TStringField;
    Table1Imagem: TBlobField;
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
    procedure Table1NewRecord(DataSet: TDataSet);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.DataSource1DataChange(Sender: TObject; Field: TField);
var
  BlobStream : TBlobStream;
  JpegImage : TJPEGImage;
begin
  BlobStream := TBlobStream.Create(Table1Imagem, bmRead);
  if BlobStream.Size <> 0 then begin
    JpegImage  := TJPEGImage.Create;
    try
      JpegImage.LoadFromStream(BlobStream);
      Image1.Picture.Assign(JpegImage);
    finally
      BlobStream.Free;
      JpegImage.Free;
    end;
  end;
end;

procedure TForm1.Table1NewRecord(DataSet: TDataSet);
var
  FileStream : TFileStream;
  BlobStream : TBlobStream;
begin
  if Opendialog1.Execute then begin
// abre stream com a imagem do arquivo
    FileStream := TFileStream.Create(OpenDialog1.FileName,
      fmOpenRead or fmShareDenyWrite);
// abre stream de gravao do blob
    BlobStream := TBlobStream.Create(Table1Imagem, bmWrite);
    try
// copia dados do stream de arquivo para o blob
      BlobStream.CopyFrom(FileStream, FileStream.Size );
    finally
      FileStream.Free;
      BlobStream.Free;
    end;
  end
  else
    Abort;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Table1.DatabaseName := ExtractFilePath(ParamStr(0));
  Table1.Open;
end;

end.
